#!/usr/bin/python2

import sys


WRONG_OUTPUT_FORMAT = "Incorrectly formatted output.";
TEST_DATA_ERROR = "Error in official input or output.";
WRONG = "Incorrect.";
CORRECT = "Correct.";


def finish(score, message):
    print score
    print message
    sys.exit(0)

MAX = 10**100

def good_triple(k, a, b, c):
    return a*a + b*b + c*c == k*(a*b + b*c + c*a) + 1

def main(argv):
    assert len(argv) == 4

    try:
        fin = file(argv[1], "rt")
        foff = file(argv[2], "rt")
        fout = file(argv[3], "rt")
    except IOError, e:
        finish(0, TEST_DATA_ERROR + ' ' + str(e))

    assert not fin.closed
    assert not fout.closed
    assert not foff.closed

    # read official input
    try:
        k, n = map(int, fin.readline().split())
    except ValueError, e:
        finish(0, TEST_DATA_ERROR + ' ' + str(e))
        
    # read official output

    # read contestant output
    solutions = []
    try:
        for line in fout.readlines():
            if line.strip():
                a, b, c = map(int, line.strip().split())
                solutions.append((a, b, c))
    except ValueError, e:
        finish(0, WRONG_OUTPUT_FORMAT + ' ' + str(e))

    # check
    if len(solutions) < n:
        finish(0, "{} Not enough solutions printed.".format(WRONG))
    if len(solutions) > n:
        finish(0, "{} Too many solutions printed.".format(WRONG))

    numbers = set()
    for a, b, c in solutions:
        if not (a > 0 and b > 0 and c > 0):
            finish(0, "{} Number in a triple is not natural.".format(WRONG))
        if not (a < MAX and b < MAX and c < MAX):
            finish(0, "{} Number in a triple is too big.".format(WRONG))
        if not good_triple(k, a, b, c):
            finish(0, "{} Triple ({}, {}, {}) is not a valid solution.".format(WRONG, a, b, c))
        for x in (a, b, c):
            numbers.add(x)
            
    if len(numbers) != 3*n:
        finish(0, "{} Numbers in the output are not unique.".format(WRONG))
        
    finish(1, CORRECT)


if __name__ == "__main__":
    main(sys.argv)
