// Checker to be used by evaluator.
//
// Usage: [checker] [input] [official_output] [contestant_output]
//
// Score (real between 0.0 and 1.0) written on stdout.
// Textual description of the result written on stderr.

#include <algorithm>
#include <cassert>
#include <cstdlib>
#include <cstring>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>

using namespace std;

void Finish(double p, const string& m) {
  cout << p << endl;
  cout << m << endl;
  exit(0);
}

void Move(int k, vector<int>* a, vector<int>* b) {
  b->insert(b->end(), a->end() - k, a->end());
  a->erase(a->end() - k, a->end());
}

vector<int> a[6][6];

const string OUT_OF_BOUNDS = "Rod coordinates out of bounds.";
const string NUM_DISKS_NOT_POSITIVE = "Number of disks must be a positive integer.";
const string NOT_ENOUGH_DISKS_ON_ROD = "Not enough disks on selected rod.";
const string TARGET_OUT_OF_BOUNDS = "There is no target rod in the given direction.";
const string INVALID_STEP_DESCRIPTION = "Invalid step description.";
const string DISKS_NOT_AT_FINAL_ROD = "Some disks not at the final rod.";
const string DISKS_NOT_SORTED = "Disks are not sorted at the final rod.";
const string CORRECT = "Correct.";

int main(int argc, char *argv[]) {
  assert(argc == 4);

  ifstream fin(argv[1]); 
  ifstream fout(argv[3]);

  int n;
  fin >> n;
  a[0][0].resize(n);
  for (int i = 0; i < n; ++i) fin >> a[0][0][i];

  string line;
  while (getline(fout, line)) {
    if (line.empty()) continue;
    istringstream iss(line);
    int row, col, k;
    string dir;
    if (!(iss >> row >> col >> dir >> k)) {
      Finish(0.0, INVALID_STEP_DESCRIPTION);
    }
    string tmp;
    if (iss >> tmp) {
      Finish(0.0, INVALID_STEP_DESCRIPTION);
    }
    --row; --col;
    if (row < 0 || row > 5) Finish(0.0, OUT_OF_BOUNDS);
    if (col < 0 || col > 5) Finish(0.0, OUT_OF_BOUNDS);
    if (k < 1) Finish(0.0, NUM_DISKS_NOT_POSITIVE);
    if (k > (int)a[row][col].size()) Finish(0.0, NOT_ENOUGH_DISKS_ON_ROD);
    if (dir == "D") {
      if (row == 5) Finish(0.0, TARGET_OUT_OF_BOUNDS);
      Move(k, &a[row][col], &a[row + 1][col]);
    } else if (dir == "R") {
      if (col == 5) Finish(0.0, TARGET_OUT_OF_BOUNDS);
      Move(k, &a[row][col], &a[row][col + 1]);
    } else {
      Finish(0.0, INVALID_STEP_DESCRIPTION);
    }
  }
  if ((int)a[5][5].size() != n) Finish(0.0, DISKS_NOT_AT_FINAL_ROD);
  for (int i = 0; i < n; ++i) {
    if (a[5][5][i] != n - i) Finish(0.0, DISKS_NOT_SORTED);
  }
  Finish(1.0, CORRECT);

  return 0;
}
