#include <cstdio>
#include <string>
#include <vector>
#include <iostream>
#include <set>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<


const int MAXN = 55;

string identifier(bool nneg, int x) {
  return string(!nneg ? "!" : "") + "x" + to_string(x + 1);
}

string imp(bool negx, int x, bool negy, int y) {
  return identifier(negx, x) + " -> " + identifier(negy, y);
}

int N;
int x[3][MAXN];

int id[8];
vector< int > v[8];

int main(void)
{
  scanf("%d", &N);
  REP(i, 3) REP(j, N)
    scanf("%d", &x[i][j]);

  REP(i, 3) id[1 << i] = i;
  REP(i, N) {
    int idx = 0;
    REP(j, 3) idx += (x[j][i] << j);
    v[idx].push_back(i);
  }

  vector< string > imps;
  set< int > s;

  REP(pat, 8) {
    if (v[pat].empty()) continue;
    
    int r = -1;
    if (__builtin_popcount(pat) == 1)
      r = id[pat];
    else if (__builtin_popcount(pat) == 2)
      r = id[~pat & 7];
    else {
      int b = pat & 1;
      for (int x : v[pat])
	imps.push_back(imp(!b, x, b, x));
      continue;
    }

    s.insert(r);
    int b = (pat >> r) & 1;

    REP(i, (int)v[pat].size())
      imps.push_back(imp(b, v[pat][i], b, v[pat][(i + 1) % v[pat].size()]));

    REP(pat2, 8) 
      if (pat2 != 0 && pat2 != 7 && !v[pat2].empty() && pat != pat2) 
	imps.push_back(imp(b, v[pat][0], (pat2 >> r) & 1, v[pat2][0]));
  }

  if ((int)s.size() == 3)
    puts("-1");
  else {
    printf("%d\n", (int)imps.size());
    for (string i : imps)
      printf("%s\n", i.c_str());
  }
  
  return 0;
}
