#include <algorithm>

#include <cassert>
#include <cstring>
#include <cstdio>
#include <cstdlib>

#include <set>
#include <vector>
#include <iostream>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

const int MAXN = 20;

int na, nb;
int wa[MAXN], wb[MAXN];
char grid[MAXN][MAXN];
int mask_right[MAXN];
int mask_left[MAXN];

vector<int> solve() {
  static int can[1<<MAXN];
  vector<int> ans;

  can[0] = true;

  REP(state, 1<<na) {
    int s = 0, pcnt = 0;
    can[state] = true;
    REP(i, na) if (state&(1<<i)) can[state] &= can[state-(1<<i)];
    REP(i, na) if (state&(1<<i)) ++pcnt, s += wa[i];

    int c = 0;
    REP(j, nb) if (mask_right[j]&state) ++c;

    if (c < pcnt) can[state] = false;
    if (can[state]) {
      ans.push_back(s);
    }
  }

  sort(ans.begin(), ans.end());
  return ans;
}

int main(void) {
  scanf("%d %d", &na, &nb);
  REP(i, na) REP(j, nb) { 
    scanf(" %c", &grid[i][j]); grid[i][j] -= '0';
    if (grid[i][j]) mask_right[j] |= 1<<i, mask_left[i] |= 1<<j;
  }
  REP(i, na) scanf("%d", wa+i);
  REP(i, nb) scanf("%d", wb+i);

  vector<int> L = solve();
  REP(i, MAXN) REP(j, i) swap(grid[i][j], grid[j][i]);
  REP(i, MAXN) swap(wa[i], wb[i]);
  REP(i, MAXN) swap(mask_right[i], mask_left[i]);
  swap(na, nb);
  vector<int> R = solve();

  int t; scanf("%d", &t);
  llint ans = 0;
  for (int a : L) {
    ans += R.end() - lower_bound(R.begin(), R.end(), t-a);
  }
  printf("%lld\n", ans);

  return 0;
}
